/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class DeviceDetails {
    private final String deviceId;
    private final String deviceInstallationId;
    private final String deviceName;

    @JsonCreator
    public DeviceDetails(@JsonProperty(value="device_id") String deviceId, @JsonProperty(value="device_installation_id") String deviceInstallationId, @JsonProperty(value="device_name") String deviceName) {
        this.deviceId = deviceId;
        this.deviceInstallationId = deviceInstallationId;
        this.deviceName = deviceName;
    }

    @JsonGetter(value="device_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonGetter(value="device_installation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeviceInstallationId() {
        return this.deviceInstallationId;
    }

    @JsonGetter(value="device_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeviceName() {
        return this.deviceName;
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.deviceInstallationId, this.deviceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceDetails)) {
            return false;
        }
        DeviceDetails other = (DeviceDetails)obj;
        return Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.deviceInstallationId, other.deviceInstallationId) && Objects.equals(this.deviceName, other.deviceName);
    }

    public String toString() {
        return "DeviceDetails [deviceId=" + this.deviceId + ", deviceInstallationId=" + this.deviceInstallationId + ", deviceName=" + this.deviceName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().deviceId(this.getDeviceId()).deviceInstallationId(this.getDeviceInstallationId()).deviceName(this.getDeviceName());
        return builder;
    }

    public static class Builder {
        private String deviceId;
        private String deviceInstallationId;
        private String deviceName;

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceInstallationId(String deviceInstallationId) {
            this.deviceInstallationId = deviceInstallationId;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public DeviceDetails build() {
            return new DeviceDetails(this.deviceId, this.deviceInstallationId, this.deviceName);
        }
    }
}

