/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.DisputedPayment;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class Dispute {
    private final String disputeId;
    private final String id;
    private final Money amountMoney;
    private final String reason;
    private final String state;
    private final String dueAt;
    private final DisputedPayment disputedPayment;
    private final List<String> evidenceIds;
    private final String cardBrand;
    private final String createdAt;
    private final String updatedAt;
    private final String brandDisputeId;
    private final String reportedDate;
    private final String reportedAt;
    private final Integer version;
    private final String locationId;

    @JsonCreator
    public Dispute(@JsonProperty(value="dispute_id") String disputeId, @JsonProperty(value="id") String id, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reason") String reason, @JsonProperty(value="state") String state, @JsonProperty(value="due_at") String dueAt, @JsonProperty(value="disputed_payment") DisputedPayment disputedPayment, @JsonProperty(value="evidence_ids") List<String> evidenceIds, @JsonProperty(value="card_brand") String cardBrand, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="brand_dispute_id") String brandDisputeId, @JsonProperty(value="reported_date") String reportedDate, @JsonProperty(value="reported_at") String reportedAt, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId) {
        this.disputeId = disputeId;
        this.id = id;
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.state = state;
        this.dueAt = dueAt;
        this.disputedPayment = disputedPayment;
        this.evidenceIds = evidenceIds;
        this.cardBrand = cardBrand;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.brandDisputeId = brandDisputeId;
        this.reportedDate = reportedDate;
        this.reportedAt = reportedAt;
        this.version = version;
        this.locationId = locationId;
    }

    @JsonGetter(value="dispute_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDisputeId() {
        return this.disputeId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="due_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDueAt() {
        return this.dueAt;
    }

    @JsonGetter(value="disputed_payment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisputedPayment getDisputedPayment() {
        return this.disputedPayment;
    }

    @JsonGetter(value="evidence_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getEvidenceIds() {
        return this.evidenceIds;
    }

    @JsonGetter(value="card_brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardBrand() {
        return this.cardBrand;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="brand_dispute_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandDisputeId() {
        return this.brandDisputeId;
    }

    @JsonGetter(value="reported_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReportedDate() {
        return this.reportedDate;
    }

    @JsonGetter(value="reported_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReportedAt() {
        return this.reportedAt;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.disputeId, this.id, this.amountMoney, this.reason, this.state, this.dueAt, this.disputedPayment, this.evidenceIds, this.cardBrand, this.createdAt, this.updatedAt, this.brandDisputeId, this.reportedDate, this.reportedAt, this.version, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)obj;
        return Objects.equals(this.disputeId, other.disputeId) && Objects.equals(this.id, other.id) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.reason, other.reason) && Objects.equals(this.state, other.state) && Objects.equals(this.dueAt, other.dueAt) && Objects.equals(this.disputedPayment, other.disputedPayment) && Objects.equals(this.evidenceIds, other.evidenceIds) && Objects.equals(this.cardBrand, other.cardBrand) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.brandDisputeId, other.brandDisputeId) && Objects.equals(this.reportedDate, other.reportedDate) && Objects.equals(this.reportedAt, other.reportedAt) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "Dispute [disputeId=" + this.disputeId + ", id=" + this.id + ", amountMoney=" + this.amountMoney + ", reason=" + this.reason + ", state=" + this.state + ", dueAt=" + this.dueAt + ", disputedPayment=" + this.disputedPayment + ", evidenceIds=" + this.evidenceIds + ", cardBrand=" + this.cardBrand + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", brandDisputeId=" + this.brandDisputeId + ", reportedDate=" + this.reportedDate + ", reportedAt=" + this.reportedAt + ", version=" + this.version + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().disputeId(this.getDisputeId()).id(this.getId()).amountMoney(this.getAmountMoney()).reason(this.getReason()).state(this.getState()).dueAt(this.getDueAt()).disputedPayment(this.getDisputedPayment()).evidenceIds(this.getEvidenceIds()).cardBrand(this.getCardBrand()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).brandDisputeId(this.getBrandDisputeId()).reportedDate(this.getReportedDate()).reportedAt(this.getReportedAt()).version(this.getVersion()).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private String disputeId;
        private String id;
        private Money amountMoney;
        private String reason;
        private String state;
        private String dueAt;
        private DisputedPayment disputedPayment;
        private List<String> evidenceIds;
        private String cardBrand;
        private String createdAt;
        private String updatedAt;
        private String brandDisputeId;
        private String reportedDate;
        private String reportedAt;
        private Integer version;
        private String locationId;

        public Builder disputeId(String disputeId) {
            this.disputeId = disputeId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder dueAt(String dueAt) {
            this.dueAt = dueAt;
            return this;
        }

        public Builder disputedPayment(DisputedPayment disputedPayment) {
            this.disputedPayment = disputedPayment;
            return this;
        }

        public Builder evidenceIds(List<String> evidenceIds) {
            this.evidenceIds = evidenceIds;
            return this;
        }

        public Builder cardBrand(String cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder brandDisputeId(String brandDisputeId) {
            this.brandDisputeId = brandDisputeId;
            return this;
        }

        public Builder reportedDate(String reportedDate) {
            this.reportedDate = reportedDate;
            return this;
        }

        public Builder reportedAt(String reportedAt) {
            this.reportedAt = reportedAt;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Dispute build() {
            return new Dispute(this.disputeId, this.id, this.amountMoney, this.reason, this.state, this.dueAt, this.disputedPayment, this.evidenceIds, this.cardBrand, this.createdAt, this.updatedAt, this.brandDisputeId, this.reportedDate, this.reportedAt, this.version, this.locationId);
        }
    }
}

