/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.DisputeEvidenceFile;
import java.util.Objects;

public class DisputeEvidence {
    private final String evidenceId;
    private final String id;
    private final String disputeId;
    private final DisputeEvidenceFile evidenceFile;
    private final String evidenceText;
    private final String uploadedAt;
    private final String evidenceType;

    @JsonCreator
    public DisputeEvidence(@JsonProperty(value="evidence_id") String evidenceId, @JsonProperty(value="id") String id, @JsonProperty(value="dispute_id") String disputeId, @JsonProperty(value="evidence_file") DisputeEvidenceFile evidenceFile, @JsonProperty(value="evidence_text") String evidenceText, @JsonProperty(value="uploaded_at") String uploadedAt, @JsonProperty(value="evidence_type") String evidenceType) {
        this.evidenceId = evidenceId;
        this.id = id;
        this.disputeId = disputeId;
        this.evidenceFile = evidenceFile;
        this.evidenceText = evidenceText;
        this.uploadedAt = uploadedAt;
        this.evidenceType = evidenceType;
    }

    @JsonGetter(value="evidence_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEvidenceId() {
        return this.evidenceId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="dispute_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDisputeId() {
        return this.disputeId;
    }

    @JsonGetter(value="evidence_file")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisputeEvidenceFile getEvidenceFile() {
        return this.evidenceFile;
    }

    @JsonGetter(value="evidence_text")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEvidenceText() {
        return this.evidenceText;
    }

    @JsonGetter(value="uploaded_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUploadedAt() {
        return this.uploadedAt;
    }

    @JsonGetter(value="evidence_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEvidenceType() {
        return this.evidenceType;
    }

    public int hashCode() {
        return Objects.hash(this.evidenceId, this.id, this.disputeId, this.evidenceFile, this.evidenceText, this.uploadedAt, this.evidenceType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DisputeEvidence)) {
            return false;
        }
        DisputeEvidence other = (DisputeEvidence)obj;
        return Objects.equals(this.evidenceId, other.evidenceId) && Objects.equals(this.id, other.id) && Objects.equals(this.disputeId, other.disputeId) && Objects.equals(this.evidenceFile, other.evidenceFile) && Objects.equals(this.evidenceText, other.evidenceText) && Objects.equals(this.uploadedAt, other.uploadedAt) && Objects.equals(this.evidenceType, other.evidenceType);
    }

    public String toString() {
        return "DisputeEvidence [evidenceId=" + this.evidenceId + ", id=" + this.id + ", disputeId=" + this.disputeId + ", evidenceFile=" + this.evidenceFile + ", evidenceText=" + this.evidenceText + ", uploadedAt=" + this.uploadedAt + ", evidenceType=" + this.evidenceType + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().evidenceId(this.getEvidenceId()).id(this.getId()).disputeId(this.getDisputeId()).evidenceFile(this.getEvidenceFile()).evidenceText(this.getEvidenceText()).uploadedAt(this.getUploadedAt()).evidenceType(this.getEvidenceType());
        return builder;
    }

    public static class Builder {
        private String evidenceId;
        private String id;
        private String disputeId;
        private DisputeEvidenceFile evidenceFile;
        private String evidenceText;
        private String uploadedAt;
        private String evidenceType;

        public Builder evidenceId(String evidenceId) {
            this.evidenceId = evidenceId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder disputeId(String disputeId) {
            this.disputeId = disputeId;
            return this;
        }

        public Builder evidenceFile(DisputeEvidenceFile evidenceFile) {
            this.evidenceFile = evidenceFile;
            return this;
        }

        public Builder evidenceText(String evidenceText) {
            this.evidenceText = evidenceText;
            return this;
        }

        public Builder uploadedAt(String uploadedAt) {
            this.uploadedAt = uploadedAt;
            return this;
        }

        public Builder evidenceType(String evidenceType) {
            this.evidenceType = evidenceType;
            return this;
        }

        public DisputeEvidence build() {
            return new DisputeEvidence(this.evidenceId, this.id, this.disputeId, this.evidenceFile, this.evidenceText, this.uploadedAt, this.evidenceType);
        }
    }
}

