/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.DisputeEvidenceCreatedWebhookData;
import java.util.Objects;

public class DisputeEvidenceCreatedWebhook {
    private final String merchantId;
    private final String locationId;
    private final String type;
    private final String eventId;
    private final String createdAt;
    private final DisputeEvidenceCreatedWebhookData data;

    @JsonCreator
    public DisputeEvidenceCreatedWebhook(@JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="type") String type, @JsonProperty(value="event_id") String eventId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="data") DisputeEvidenceCreatedWebhookData data) {
        this.merchantId = merchantId;
        this.locationId = locationId;
        this.type = type;
        this.eventId = eventId;
        this.createdAt = createdAt;
        this.data = data;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="event_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEventId() {
        return this.eventId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisputeEvidenceCreatedWebhookData getData() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.locationId, this.type, this.eventId, this.createdAt, this.data);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DisputeEvidenceCreatedWebhook)) {
            return false;
        }
        DisputeEvidenceCreatedWebhook other = (DisputeEvidenceCreatedWebhook)obj;
        return Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.type, other.type) && Objects.equals(this.eventId, other.eventId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return "DisputeEvidenceCreatedWebhook [merchantId=" + this.merchantId + ", locationId=" + this.locationId + ", type=" + this.type + ", eventId=" + this.eventId + ", createdAt=" + this.createdAt + ", data=" + this.data + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().merchantId(this.getMerchantId()).locationId(this.getLocationId()).type(this.getType()).eventId(this.getEventId()).createdAt(this.getCreatedAt()).data(this.getData());
        return builder;
    }

    public static class Builder {
        private String merchantId;
        private String locationId;
        private String type;
        private String eventId;
        private String createdAt;
        private DisputeEvidenceCreatedWebhookData data;

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder data(DisputeEvidenceCreatedWebhookData data) {
            this.data = data;
            return this;
        }

        public DisputeEvidenceCreatedWebhook build() {
            return new DisputeEvidenceCreatedWebhook(this.merchantId, this.locationId, this.type, this.eventId, this.createdAt, this.data);
        }
    }
}

