/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class Employee {
    private final String id;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String phoneNumber;
    private final List<String> locationIds;
    private final String status;
    private final Boolean isOwner;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public Employee(@JsonProperty(value="id") String id, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="email") String email, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="status") String status, @JsonProperty(value="is_owner") Boolean isOwner, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phoneNumber = phoneNumber;
        this.locationIds = locationIds;
        this.status = status;
        this.isOwner = isOwner;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="first_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonGetter(value="last_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLastName() {
        return this.lastName;
    }

    @JsonGetter(value="email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmail() {
        return this.email;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="is_owner")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsOwner() {
        return this.isOwner;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.email, this.phoneNumber, this.locationIds, this.status, this.isOwner, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Employee)) {
            return false;
        }
        Employee other = (Employee)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && Objects.equals(this.email, other.email) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.status, other.status) && Objects.equals(this.isOwner, other.isOwner) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "Employee [id=" + this.id + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", phoneNumber=" + this.phoneNumber + ", locationIds=" + this.locationIds + ", status=" + this.status + ", isOwner=" + this.isOwner + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).firstName(this.getFirstName()).lastName(this.getLastName()).email(this.getEmail()).phoneNumber(this.getPhoneNumber()).locationIds(this.getLocationIds()).status(this.getStatus()).isOwner(this.getIsOwner()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String id;
        private String firstName;
        private String lastName;
        private String email;
        private String phoneNumber;
        private List<String> locationIds;
        private String status;
        private Boolean isOwner;
        private String createdAt;
        private String updatedAt;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = isOwner;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Employee build() {
            return new Employee(this.id, this.firstName, this.lastName, this.email, this.phoneNumber, this.locationIds, this.status, this.isOwner, this.createdAt, this.updatedAt);
        }
    }
}

