/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Error {
    private final String category;
    private final String code;
    private final String detail;
    private final String field;

    @JsonCreator
    public Error(@JsonProperty(value="category") String category, @JsonProperty(value="code") String code, @JsonProperty(value="detail") String detail, @JsonProperty(value="field") String field) {
        this.category = category;
        this.code = code;
        this.detail = detail;
        this.field = field;
    }

    @JsonGetter(value="category")
    public String getCategory() {
        return this.category;
    }

    @JsonGetter(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonGetter(value="detail")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDetail() {
        return this.detail;
    }

    @JsonGetter(value="field")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getField() {
        return this.field;
    }

    public int hashCode() {
        return Objects.hash(this.category, this.code, this.detail, this.field);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Error)) {
            return false;
        }
        Error other = (Error)obj;
        return Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.detail, other.detail) && Objects.equals(this.field, other.field);
    }

    public String toString() {
        return "Error [category=" + this.category + ", code=" + this.code + ", detail=" + this.detail + ", field=" + this.field + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.category, this.code).detail(this.getDetail()).field(this.getField());
        return builder;
    }

    public static class Builder {
        private String category;
        private String code;
        private String detail;
        private String field;

        public Builder(String category, String code) {
            this.category = category;
            this.code = code;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Error build() {
            return new Error(this.category, this.code, this.detail, this.field);
        }
    }
}

