/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class ExternalPaymentDetails {
    private final String type;
    private final String source;
    private final String sourceId;
    private final Money sourceFeeMoney;

    @JsonCreator
    public ExternalPaymentDetails(@JsonProperty(value="type") String type, @JsonProperty(value="source") String source, @JsonProperty(value="source_id") String sourceId, @JsonProperty(value="source_fee_money") Money sourceFeeMoney) {
        this.type = type;
        this.source = source;
        this.sourceId = sourceId;
        this.sourceFeeMoney = sourceFeeMoney;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonGetter(value="source_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceId() {
        return this.sourceId;
    }

    @JsonGetter(value="source_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getSourceFeeMoney() {
        return this.sourceFeeMoney;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.sourceId, this.sourceFeeMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExternalPaymentDetails)) {
            return false;
        }
        ExternalPaymentDetails other = (ExternalPaymentDetails)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.sourceFeeMoney, other.sourceFeeMoney);
    }

    public String toString() {
        return "ExternalPaymentDetails [type=" + this.type + ", source=" + this.source + ", sourceId=" + this.sourceId + ", sourceFeeMoney=" + this.sourceFeeMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type, this.source).sourceId(this.getSourceId()).sourceFeeMoney(this.getSourceFeeMoney());
        return builder;
    }

    public static class Builder {
        private String type;
        private String source;
        private String sourceId;
        private Money sourceFeeMoney;

        public Builder(String type, String source) {
            this.type = type;
            this.source = source;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder sourceFeeMoney(Money sourceFeeMoney) {
            this.sourceFeeMoney = sourceFeeMoney;
            return this;
        }

        public ExternalPaymentDetails build() {
            return new ExternalPaymentDetails(this.type, this.source, this.sourceId, this.sourceFeeMoney);
        }
    }
}

