/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class FilterValue {
    private final List<String> all;
    private final List<String> any;
    private final List<String> none;

    @JsonCreator
    public FilterValue(@JsonProperty(value="all") List<String> all, @JsonProperty(value="any") List<String> any, @JsonProperty(value="none") List<String> none) {
        this.all = all;
        this.any = any;
        this.none = none;
    }

    @JsonGetter(value="all")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAll() {
        return this.all;
    }

    @JsonGetter(value="any")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAny() {
        return this.any;
    }

    @JsonGetter(value="none")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getNone() {
        return this.none;
    }

    public int hashCode() {
        return Objects.hash(this.all, this.any, this.none);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilterValue)) {
            return false;
        }
        FilterValue other = (FilterValue)obj;
        return Objects.equals(this.all, other.all) && Objects.equals(this.any, other.any) && Objects.equals(this.none, other.none);
    }

    public String toString() {
        return "FilterValue [all=" + this.all + ", any=" + this.any + ", none=" + this.none + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().all(this.getAll()).any(this.getAny()).none(this.getNone());
        return builder;
    }

    public static class Builder {
        private List<String> all;
        private List<String> any;
        private List<String> none;

        public Builder all(List<String> all) {
            this.all = all;
            return this;
        }

        public Builder any(List<String> any) {
            this.any = any;
            return this;
        }

        public Builder none(List<String> none) {
            this.none = none;
            return this;
        }

        public FilterValue build() {
            return new FilterValue(this.all, this.any, this.none);
        }
    }
}

