/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.BankAccount;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class GetBankAccountByV1IdResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final BankAccount bankAccount;

    @JsonCreator
    public GetBankAccountByV1IdResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="bank_account") BankAccount bankAccount) {
        this.errors = errors;
        this.bankAccount = bankAccount;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="bank_account")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.bankAccount);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GetBankAccountByV1IdResponse)) {
            return false;
        }
        GetBankAccountByV1IdResponse other = (GetBankAccountByV1IdResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.bankAccount, other.bankAccount);
    }

    public String toString() {
        return "GetBankAccountByV1IdResponse [errors=" + this.errors + ", bankAccount=" + this.bankAccount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).bankAccount(this.getBankAccount());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private BankAccount bankAccount;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder bankAccount(BankAccount bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public GetBankAccountByV1IdResponse build() {
            GetBankAccountByV1IdResponse model = new GetBankAccountByV1IdResponse(this.errors, this.bankAccount);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

