/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Payout;
import java.util.List;
import java.util.Objects;

public class GetPayoutResponse {
    private HttpContext httpContext;
    private final Payout payout;
    private final List<Error> errors;

    @JsonCreator
    public GetPayoutResponse(@JsonProperty(value="payout") Payout payout, @JsonProperty(value="errors") List<Error> errors) {
        this.payout = payout;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="payout")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Payout getPayout() {
        return this.payout;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.payout, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GetPayoutResponse)) {
            return false;
        }
        GetPayoutResponse other = (GetPayoutResponse)obj;
        return Objects.equals(this.payout, other.payout) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "GetPayoutResponse [payout=" + this.payout + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().payout(this.getPayout()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Payout payout;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder payout(Payout payout) {
            this.payout = payout;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public GetPayoutResponse build() {
            GetPayoutResponse model = new GetPayoutResponse(this.payout, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

