/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class GiftCardActivityLoad {
    private final Money amountMoney;
    private final String orderId;
    private final String lineItemUid;
    private final String referenceId;
    private final List<String> buyerPaymentInstrumentIds;

    @JsonCreator
    public GiftCardActivityLoad(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="line_item_uid") String lineItemUid, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="buyer_payment_instrument_ids") List<String> buyerPaymentInstrumentIds) {
        this.amountMoney = amountMoney;
        this.orderId = orderId;
        this.lineItemUid = lineItemUid;
        this.referenceId = referenceId;
        this.buyerPaymentInstrumentIds = buyerPaymentInstrumentIds;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="line_item_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLineItemUid() {
        return this.lineItemUid;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="buyer_payment_instrument_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getBuyerPaymentInstrumentIds() {
        return this.buyerPaymentInstrumentIds;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.orderId, this.lineItemUid, this.referenceId, this.buyerPaymentInstrumentIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityLoad)) {
            return false;
        }
        GiftCardActivityLoad other = (GiftCardActivityLoad)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.lineItemUid, other.lineItemUid) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.buyerPaymentInstrumentIds, other.buyerPaymentInstrumentIds);
    }

    public String toString() {
        return "GiftCardActivityLoad [amountMoney=" + this.amountMoney + ", orderId=" + this.orderId + ", lineItemUid=" + this.lineItemUid + ", referenceId=" + this.referenceId + ", buyerPaymentInstrumentIds=" + this.buyerPaymentInstrumentIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amountMoney(this.getAmountMoney()).orderId(this.getOrderId()).lineItemUid(this.getLineItemUid()).referenceId(this.getReferenceId()).buyerPaymentInstrumentIds(this.getBuyerPaymentInstrumentIds());
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private String orderId;
        private String lineItemUid;
        private String referenceId;
        private List<String> buyerPaymentInstrumentIds;

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder lineItemUid(String lineItemUid) {
            this.lineItemUid = lineItemUid;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder buyerPaymentInstrumentIds(List<String> buyerPaymentInstrumentIds) {
            this.buyerPaymentInstrumentIds = buyerPaymentInstrumentIds;
            return this;
        }

        public GiftCardActivityLoad build() {
            return new GiftCardActivityLoad(this.amountMoney, this.orderId, this.lineItemUid, this.referenceId, this.buyerPaymentInstrumentIds);
        }
    }
}

