/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class GiftCardActivityRedeem {
    private final Money amountMoney;
    private final String paymentId;
    private final String referenceId;

    @JsonCreator
    public GiftCardActivityRedeem(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="reference_id") String referenceId) {
        this.amountMoney = amountMoney;
        this.paymentId = paymentId;
        this.referenceId = referenceId;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.paymentId, this.referenceId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityRedeem)) {
            return false;
        }
        GiftCardActivityRedeem other = (GiftCardActivityRedeem)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.referenceId, other.referenceId);
    }

    public String toString() {
        return "GiftCardActivityRedeem [amountMoney=" + this.amountMoney + ", paymentId=" + this.paymentId + ", referenceId=" + this.referenceId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amountMoney).paymentId(this.getPaymentId()).referenceId(this.getReferenceId());
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private String paymentId;
        private String referenceId;

        public Builder(Money amountMoney) {
            this.amountMoney = amountMoney;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public GiftCardActivityRedeem build() {
            return new GiftCardActivityRedeem(this.amountMoney, this.paymentId, this.referenceId);
        }
    }
}

