/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class GiftCardActivityRefund {
    private final String redeemActivityId;
    private final Money amountMoney;
    private final String referenceId;
    private final String paymentId;

    @JsonCreator
    public GiftCardActivityRefund(@JsonProperty(value="redeem_activity_id") String redeemActivityId, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="payment_id") String paymentId) {
        this.redeemActivityId = redeemActivityId;
        this.amountMoney = amountMoney;
        this.referenceId = referenceId;
        this.paymentId = paymentId;
    }

    @JsonGetter(value="redeem_activity_id")
    public String getRedeemActivityId() {
        return this.redeemActivityId;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    public int hashCode() {
        return Objects.hash(this.redeemActivityId, this.amountMoney, this.referenceId, this.paymentId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityRefund)) {
            return false;
        }
        GiftCardActivityRefund other = (GiftCardActivityRefund)obj;
        return Objects.equals(this.redeemActivityId, other.redeemActivityId) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.paymentId, other.paymentId);
    }

    public String toString() {
        return "GiftCardActivityRefund [redeemActivityId=" + this.redeemActivityId + ", amountMoney=" + this.amountMoney + ", referenceId=" + this.referenceId + ", paymentId=" + this.paymentId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.redeemActivityId).amountMoney(this.getAmountMoney()).referenceId(this.getReferenceId()).paymentId(this.getPaymentId());
        return builder;
    }

    public static class Builder {
        private String redeemActivityId;
        private Money amountMoney;
        private String referenceId;
        private String paymentId;

        public Builder(String redeemActivityId) {
            this.redeemActivityId = redeemActivityId;
        }

        public Builder redeemActivityId(String redeemActivityId) {
            this.redeemActivityId = redeemActivityId;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public GiftCardActivityRefund build() {
            return new GiftCardActivityRefund(this.redeemActivityId, this.amountMoney, this.referenceId, this.paymentId);
        }
    }
}

