/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class GiftCardActivityUnlinkedActivityRefund {
    private final Money amountMoney;
    private final String referenceId;
    private final String paymentId;

    @JsonCreator
    public GiftCardActivityUnlinkedActivityRefund(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="payment_id") String paymentId) {
        this.amountMoney = amountMoney;
        this.referenceId = referenceId;
        this.paymentId = paymentId;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.referenceId, this.paymentId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityUnlinkedActivityRefund)) {
            return false;
        }
        GiftCardActivityUnlinkedActivityRefund other = (GiftCardActivityUnlinkedActivityRefund)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.paymentId, other.paymentId);
    }

    public String toString() {
        return "GiftCardActivityUnlinkedActivityRefund [amountMoney=" + this.amountMoney + ", referenceId=" + this.referenceId + ", paymentId=" + this.paymentId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amountMoney).referenceId(this.getReferenceId()).paymentId(this.getPaymentId());
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private String referenceId;
        private String paymentId;

        public Builder(Money amountMoney) {
            this.amountMoney = amountMoney;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public GiftCardActivityUnlinkedActivityRefund build() {
            return new GiftCardActivityUnlinkedActivityRefund(this.amountMoney, this.referenceId, this.paymentId);
        }
    }
}

