/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class InventoryCount {
    private final String catalogObjectId;
    private final String catalogObjectType;
    private final String state;
    private final String locationId;
    private final String quantity;
    private final String calculatedAt;
    private final Boolean isEstimated;

    @JsonCreator
    public InventoryCount(@JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_object_type") String catalogObjectType, @JsonProperty(value="state") String state, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="calculated_at") String calculatedAt, @JsonProperty(value="is_estimated") Boolean isEstimated) {
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.state = state;
        this.locationId = locationId;
        this.quantity = quantity;
        this.calculatedAt = calculatedAt;
        this.isEstimated = isEstimated;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_object_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="calculated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCalculatedAt() {
        return this.calculatedAt;
    }

    @JsonGetter(value="is_estimated")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsEstimated() {
        return this.isEstimated;
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt, this.isEstimated);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InventoryCount)) {
            return false;
        }
        InventoryCount other = (InventoryCount)obj;
        return Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogObjectType, other.catalogObjectType) && Objects.equals(this.state, other.state) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.calculatedAt, other.calculatedAt) && Objects.equals(this.isEstimated, other.isEstimated);
    }

    public String toString() {
        return "InventoryCount [catalogObjectId=" + this.catalogObjectId + ", catalogObjectType=" + this.catalogObjectType + ", state=" + this.state + ", locationId=" + this.locationId + ", quantity=" + this.quantity + ", calculatedAt=" + this.calculatedAt + ", isEstimated=" + this.isEstimated + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().catalogObjectId(this.getCatalogObjectId()).catalogObjectType(this.getCatalogObjectType()).state(this.getState()).locationId(this.getLocationId()).quantity(this.getQuantity()).calculatedAt(this.getCalculatedAt()).isEstimated(this.getIsEstimated());
        return builder;
    }

    public static class Builder {
        private String catalogObjectId;
        private String catalogObjectType;
        private String state;
        private String locationId;
        private String quantity;
        private String calculatedAt;
        private Boolean isEstimated;

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = catalogObjectType;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder calculatedAt(String calculatedAt) {
            this.calculatedAt = calculatedAt;
            return this;
        }

        public Builder isEstimated(Boolean isEstimated) {
            this.isEstimated = isEstimated;
            return this;
        }

        public InventoryCount build() {
            return new InventoryCount(this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt, this.isEstimated);
        }
    }
}

