/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SourceApplication;
import java.util.Objects;

public class InventoryTransfer {
    private final String id;
    private final String referenceId;
    private final String state;
    private final String fromLocationId;
    private final String toLocationId;
    private final String catalogObjectId;
    private final String catalogObjectType;
    private final String quantity;
    private final String occurredAt;
    private final String createdAt;
    private final SourceApplication source;
    private final String employeeId;
    private final String teamMemberId;

    @JsonCreator
    public InventoryTransfer(@JsonProperty(value="id") String id, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="state") String state, @JsonProperty(value="from_location_id") String fromLocationId, @JsonProperty(value="to_location_id") String toLocationId, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_object_type") String catalogObjectType, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="occurred_at") String occurredAt, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="source") SourceApplication source, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.id = id;
        this.referenceId = referenceId;
        this.state = state;
        this.fromLocationId = fromLocationId;
        this.toLocationId = toLocationId;
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.quantity = quantity;
        this.occurredAt = occurredAt;
        this.createdAt = createdAt;
        this.source = source;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="from_location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFromLocationId() {
        return this.fromLocationId;
    }

    @JsonGetter(value="to_location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getToLocationId() {
        return this.toLocationId;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_object_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="occurred_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOccurredAt() {
        return this.occurredAt;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SourceApplication getSource() {
        return this.source;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmployeeId() {
        return this.employeeId;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.state, this.fromLocationId, this.toLocationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.occurredAt, this.createdAt, this.source, this.employeeId, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InventoryTransfer)) {
            return false;
        }
        InventoryTransfer other = (InventoryTransfer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.state, other.state) && Objects.equals(this.fromLocationId, other.fromLocationId) && Objects.equals(this.toLocationId, other.toLocationId) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogObjectType, other.catalogObjectType) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.occurredAt, other.occurredAt) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.source, other.source) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "InventoryTransfer [id=" + this.id + ", referenceId=" + this.referenceId + ", state=" + this.state + ", fromLocationId=" + this.fromLocationId + ", toLocationId=" + this.toLocationId + ", catalogObjectId=" + this.catalogObjectId + ", catalogObjectType=" + this.catalogObjectType + ", quantity=" + this.quantity + ", occurredAt=" + this.occurredAt + ", createdAt=" + this.createdAt + ", source=" + this.source + ", employeeId=" + this.employeeId + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).referenceId(this.getReferenceId()).state(this.getState()).fromLocationId(this.getFromLocationId()).toLocationId(this.getToLocationId()).catalogObjectId(this.getCatalogObjectId()).catalogObjectType(this.getCatalogObjectType()).quantity(this.getQuantity()).occurredAt(this.getOccurredAt()).createdAt(this.getCreatedAt()).source(this.getSource()).employeeId(this.getEmployeeId()).teamMemberId(this.getTeamMemberId());
        return builder;
    }

    public static class Builder {
        private String id;
        private String referenceId;
        private String state;
        private String fromLocationId;
        private String toLocationId;
        private String catalogObjectId;
        private String catalogObjectType;
        private String quantity;
        private String occurredAt;
        private String createdAt;
        private SourceApplication source;
        private String employeeId;
        private String teamMemberId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder fromLocationId(String fromLocationId) {
            this.fromLocationId = fromLocationId;
            return this;
        }

        public Builder toLocationId(String toLocationId) {
            this.toLocationId = toLocationId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = catalogObjectType;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder occurredAt(String occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder source(SourceApplication source) {
            this.source = source;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public InventoryTransfer build() {
            return new InventoryTransfer(this.id, this.referenceId, this.state, this.fromLocationId, this.toLocationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.occurredAt, this.createdAt, this.source, this.employeeId, this.teamMemberId);
        }
    }
}

