/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.InvoiceAcceptedPaymentMethods;
import com.squareup.square.models.InvoiceCustomField;
import com.squareup.square.models.InvoicePaymentRequest;
import com.squareup.square.models.InvoiceRecipient;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class Invoice {
    private final String id;
    private final Integer version;
    private final String locationId;
    private final String orderId;
    private final InvoiceRecipient primaryRecipient;
    private final List<InvoicePaymentRequest> paymentRequests;
    private final String deliveryMethod;
    private final String invoiceNumber;
    private final String title;
    private final String description;
    private final String scheduledAt;
    private final String publicUrl;
    private final Money nextPaymentAmountMoney;
    private final String status;
    private final String timezone;
    private final String createdAt;
    private final String updatedAt;
    private final InvoiceAcceptedPaymentMethods acceptedPaymentMethods;
    private final List<InvoiceCustomField> customFields;
    private final String subscriptionId;
    private final String saleOrServiceDate;
    private final String paymentConditions;

    @JsonCreator
    public Invoice(@JsonProperty(value="id") String id, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="primary_recipient") InvoiceRecipient primaryRecipient, @JsonProperty(value="payment_requests") List<InvoicePaymentRequest> paymentRequests, @JsonProperty(value="delivery_method") String deliveryMethod, @JsonProperty(value="invoice_number") String invoiceNumber, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="scheduled_at") String scheduledAt, @JsonProperty(value="public_url") String publicUrl, @JsonProperty(value="next_payment_amount_money") Money nextPaymentAmountMoney, @JsonProperty(value="status") String status, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="accepted_payment_methods") InvoiceAcceptedPaymentMethods acceptedPaymentMethods, @JsonProperty(value="custom_fields") List<InvoiceCustomField> customFields, @JsonProperty(value="subscription_id") String subscriptionId, @JsonProperty(value="sale_or_service_date") String saleOrServiceDate, @JsonProperty(value="payment_conditions") String paymentConditions) {
        this.id = id;
        this.version = version;
        this.locationId = locationId;
        this.orderId = orderId;
        this.primaryRecipient = primaryRecipient;
        this.paymentRequests = paymentRequests;
        this.deliveryMethod = deliveryMethod;
        this.invoiceNumber = invoiceNumber;
        this.title = title;
        this.description = description;
        this.scheduledAt = scheduledAt;
        this.publicUrl = publicUrl;
        this.nextPaymentAmountMoney = nextPaymentAmountMoney;
        this.status = status;
        this.timezone = timezone;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.customFields = customFields;
        this.subscriptionId = subscriptionId;
        this.saleOrServiceDate = saleOrServiceDate;
        this.paymentConditions = paymentConditions;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="primary_recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InvoiceRecipient getPrimaryRecipient() {
        return this.primaryRecipient;
    }

    @JsonGetter(value="payment_requests")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InvoicePaymentRequest> getPaymentRequests() {
        return this.paymentRequests;
    }

    @JsonGetter(value="delivery_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    @JsonGetter(value="invoice_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="scheduled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScheduledAt() {
        return this.scheduledAt;
    }

    @JsonGetter(value="public_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPublicUrl() {
        return this.publicUrl;
    }

    @JsonGetter(value="next_payment_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getNextPaymentAmountMoney() {
        return this.nextPaymentAmountMoney;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="accepted_payment_methods")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InvoiceAcceptedPaymentMethods getAcceptedPaymentMethods() {
        return this.acceptedPaymentMethods;
    }

    @JsonGetter(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InvoiceCustomField> getCustomFields() {
        return this.customFields;
    }

    @JsonGetter(value="subscription_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonGetter(value="sale_or_service_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSaleOrServiceDate() {
        return this.saleOrServiceDate;
    }

    @JsonGetter(value="payment_conditions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentConditions() {
        return this.paymentConditions;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.locationId, this.orderId, this.primaryRecipient, this.paymentRequests, this.deliveryMethod, this.invoiceNumber, this.title, this.description, this.scheduledAt, this.publicUrl, this.nextPaymentAmountMoney, this.status, this.timezone, this.createdAt, this.updatedAt, this.acceptedPaymentMethods, this.customFields, this.subscriptionId, this.saleOrServiceDate, this.paymentConditions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.primaryRecipient, other.primaryRecipient) && Objects.equals(this.paymentRequests, other.paymentRequests) && Objects.equals(this.deliveryMethod, other.deliveryMethod) && Objects.equals(this.invoiceNumber, other.invoiceNumber) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.scheduledAt, other.scheduledAt) && Objects.equals(this.publicUrl, other.publicUrl) && Objects.equals(this.nextPaymentAmountMoney, other.nextPaymentAmountMoney) && Objects.equals(this.status, other.status) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.acceptedPaymentMethods, other.acceptedPaymentMethods) && Objects.equals(this.customFields, other.customFields) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.saleOrServiceDate, other.saleOrServiceDate) && Objects.equals(this.paymentConditions, other.paymentConditions);
    }

    public String toString() {
        return "Invoice [id=" + this.id + ", version=" + this.version + ", locationId=" + this.locationId + ", orderId=" + this.orderId + ", primaryRecipient=" + this.primaryRecipient + ", paymentRequests=" + this.paymentRequests + ", deliveryMethod=" + this.deliveryMethod + ", invoiceNumber=" + this.invoiceNumber + ", title=" + this.title + ", description=" + this.description + ", scheduledAt=" + this.scheduledAt + ", publicUrl=" + this.publicUrl + ", nextPaymentAmountMoney=" + this.nextPaymentAmountMoney + ", status=" + this.status + ", timezone=" + this.timezone + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", acceptedPaymentMethods=" + this.acceptedPaymentMethods + ", customFields=" + this.customFields + ", subscriptionId=" + this.subscriptionId + ", saleOrServiceDate=" + this.saleOrServiceDate + ", paymentConditions=" + this.paymentConditions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).version(this.getVersion()).locationId(this.getLocationId()).orderId(this.getOrderId()).primaryRecipient(this.getPrimaryRecipient()).paymentRequests(this.getPaymentRequests()).deliveryMethod(this.getDeliveryMethod()).invoiceNumber(this.getInvoiceNumber()).title(this.getTitle()).description(this.getDescription()).scheduledAt(this.getScheduledAt()).publicUrl(this.getPublicUrl()).nextPaymentAmountMoney(this.getNextPaymentAmountMoney()).status(this.getStatus()).timezone(this.getTimezone()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).acceptedPaymentMethods(this.getAcceptedPaymentMethods()).customFields(this.getCustomFields()).subscriptionId(this.getSubscriptionId()).saleOrServiceDate(this.getSaleOrServiceDate()).paymentConditions(this.getPaymentConditions());
        return builder;
    }

    public static class Builder {
        private String id;
        private Integer version;
        private String locationId;
        private String orderId;
        private InvoiceRecipient primaryRecipient;
        private List<InvoicePaymentRequest> paymentRequests;
        private String deliveryMethod;
        private String invoiceNumber;
        private String title;
        private String description;
        private String scheduledAt;
        private String publicUrl;
        private Money nextPaymentAmountMoney;
        private String status;
        private String timezone;
        private String createdAt;
        private String updatedAt;
        private InvoiceAcceptedPaymentMethods acceptedPaymentMethods;
        private List<InvoiceCustomField> customFields;
        private String subscriptionId;
        private String saleOrServiceDate;
        private String paymentConditions;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder primaryRecipient(InvoiceRecipient primaryRecipient) {
            this.primaryRecipient = primaryRecipient;
            return this;
        }

        public Builder paymentRequests(List<InvoicePaymentRequest> paymentRequests) {
            this.paymentRequests = paymentRequests;
            return this;
        }

        public Builder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public Builder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder scheduledAt(String scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public Builder publicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
            return this;
        }

        public Builder nextPaymentAmountMoney(Money nextPaymentAmountMoney) {
            this.nextPaymentAmountMoney = nextPaymentAmountMoney;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder acceptedPaymentMethods(InvoiceAcceptedPaymentMethods acceptedPaymentMethods) {
            this.acceptedPaymentMethods = acceptedPaymentMethods;
            return this;
        }

        public Builder customFields(List<InvoiceCustomField> customFields) {
            this.customFields = customFields;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder saleOrServiceDate(String saleOrServiceDate) {
            this.saleOrServiceDate = saleOrServiceDate;
            return this;
        }

        public Builder paymentConditions(String paymentConditions) {
            this.paymentConditions = paymentConditions;
            return this;
        }

        public Invoice build() {
            return new Invoice(this.id, this.version, this.locationId, this.orderId, this.primaryRecipient, this.paymentRequests, this.deliveryMethod, this.invoiceNumber, this.title, this.description, this.scheduledAt, this.publicUrl, this.nextPaymentAmountMoney, this.status, this.timezone, this.createdAt, this.updatedAt, this.acceptedPaymentMethods, this.customFields, this.subscriptionId, this.saleOrServiceDate, this.paymentConditions);
        }
    }
}

