/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class InvoiceAcceptedPaymentMethods {
    private final Boolean card;
    private final Boolean squareGiftCard;
    private final Boolean bankAccount;

    @JsonCreator
    public InvoiceAcceptedPaymentMethods(@JsonProperty(value="card") Boolean card, @JsonProperty(value="square_gift_card") Boolean squareGiftCard, @JsonProperty(value="bank_account") Boolean bankAccount) {
        this.card = card;
        this.squareGiftCard = squareGiftCard;
        this.bankAccount = bankAccount;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getCard() {
        return this.card;
    }

    @JsonGetter(value="square_gift_card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSquareGiftCard() {
        return this.squareGiftCard;
    }

    @JsonGetter(value="bank_account")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getBankAccount() {
        return this.bankAccount;
    }

    public int hashCode() {
        return Objects.hash(this.card, this.squareGiftCard, this.bankAccount);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoiceAcceptedPaymentMethods)) {
            return false;
        }
        InvoiceAcceptedPaymentMethods other = (InvoiceAcceptedPaymentMethods)obj;
        return Objects.equals(this.card, other.card) && Objects.equals(this.squareGiftCard, other.squareGiftCard) && Objects.equals(this.bankAccount, other.bankAccount);
    }

    public String toString() {
        return "InvoiceAcceptedPaymentMethods [card=" + this.card + ", squareGiftCard=" + this.squareGiftCard + ", bankAccount=" + this.bankAccount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard()).squareGiftCard(this.getSquareGiftCard()).bankAccount(this.getBankAccount());
        return builder;
    }

    public static class Builder {
        private Boolean card;
        private Boolean squareGiftCard;
        private Boolean bankAccount;

        public Builder card(Boolean card) {
            this.card = card;
            return this;
        }

        public Builder squareGiftCard(Boolean squareGiftCard) {
            this.squareGiftCard = squareGiftCard;
            return this;
        }

        public Builder bankAccount(Boolean bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public InvoiceAcceptedPaymentMethods build() {
            return new InvoiceAcceptedPaymentMethods(this.card, this.squareGiftCard, this.bankAccount);
        }
    }
}

