/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.InvoicePaymentReminder;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class InvoicePaymentRequest {
    private final String uid;
    private final String requestMethod;
    private final String requestType;
    private final String dueDate;
    private final Money fixedAmountRequestedMoney;
    private final String percentageRequested;
    private final Boolean tippingEnabled;
    private final String automaticPaymentSource;
    private final String cardId;
    private final List<InvoicePaymentReminder> reminders;
    private final Money computedAmountMoney;
    private final Money totalCompletedAmountMoney;
    private final Money roundingAdjustmentIncludedMoney;

    @JsonCreator
    public InvoicePaymentRequest(@JsonProperty(value="uid") String uid, @JsonProperty(value="request_method") String requestMethod, @JsonProperty(value="request_type") String requestType, @JsonProperty(value="due_date") String dueDate, @JsonProperty(value="fixed_amount_requested_money") Money fixedAmountRequestedMoney, @JsonProperty(value="percentage_requested") String percentageRequested, @JsonProperty(value="tipping_enabled") Boolean tippingEnabled, @JsonProperty(value="automatic_payment_source") String automaticPaymentSource, @JsonProperty(value="card_id") String cardId, @JsonProperty(value="reminders") List<InvoicePaymentReminder> reminders, @JsonProperty(value="computed_amount_money") Money computedAmountMoney, @JsonProperty(value="total_completed_amount_money") Money totalCompletedAmountMoney, @JsonProperty(value="rounding_adjustment_included_money") Money roundingAdjustmentIncludedMoney) {
        this.uid = uid;
        this.requestMethod = requestMethod;
        this.requestType = requestType;
        this.dueDate = dueDate;
        this.fixedAmountRequestedMoney = fixedAmountRequestedMoney;
        this.percentageRequested = percentageRequested;
        this.tippingEnabled = tippingEnabled;
        this.automaticPaymentSource = automaticPaymentSource;
        this.cardId = cardId;
        this.reminders = reminders;
        this.computedAmountMoney = computedAmountMoney;
        this.totalCompletedAmountMoney = totalCompletedAmountMoney;
        this.roundingAdjustmentIncludedMoney = roundingAdjustmentIncludedMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="request_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @JsonGetter(value="request_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRequestType() {
        return this.requestType;
    }

    @JsonGetter(value="due_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDueDate() {
        return this.dueDate;
    }

    @JsonGetter(value="fixed_amount_requested_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getFixedAmountRequestedMoney() {
        return this.fixedAmountRequestedMoney;
    }

    @JsonGetter(value="percentage_requested")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentageRequested() {
        return this.percentageRequested;
    }

    @JsonGetter(value="tipping_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getTippingEnabled() {
        return this.tippingEnabled;
    }

    @JsonGetter(value="automatic_payment_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAutomaticPaymentSource() {
        return this.automaticPaymentSource;
    }

    @JsonGetter(value="card_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardId() {
        return this.cardId;
    }

    @JsonGetter(value="reminders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InvoicePaymentReminder> getReminders() {
        return this.reminders;
    }

    @JsonGetter(value="computed_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getComputedAmountMoney() {
        return this.computedAmountMoney;
    }

    @JsonGetter(value="total_completed_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalCompletedAmountMoney() {
        return this.totalCompletedAmountMoney;
    }

    @JsonGetter(value="rounding_adjustment_included_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getRoundingAdjustmentIncludedMoney() {
        return this.roundingAdjustmentIncludedMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.requestMethod, this.requestType, this.dueDate, this.fixedAmountRequestedMoney, this.percentageRequested, this.tippingEnabled, this.automaticPaymentSource, this.cardId, this.reminders, this.computedAmountMoney, this.totalCompletedAmountMoney, this.roundingAdjustmentIncludedMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoicePaymentRequest)) {
            return false;
        }
        InvoicePaymentRequest other = (InvoicePaymentRequest)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.requestMethod, other.requestMethod) && Objects.equals(this.requestType, other.requestType) && Objects.equals(this.dueDate, other.dueDate) && Objects.equals(this.fixedAmountRequestedMoney, other.fixedAmountRequestedMoney) && Objects.equals(this.percentageRequested, other.percentageRequested) && Objects.equals(this.tippingEnabled, other.tippingEnabled) && Objects.equals(this.automaticPaymentSource, other.automaticPaymentSource) && Objects.equals(this.cardId, other.cardId) && Objects.equals(this.reminders, other.reminders) && Objects.equals(this.computedAmountMoney, other.computedAmountMoney) && Objects.equals(this.totalCompletedAmountMoney, other.totalCompletedAmountMoney) && Objects.equals(this.roundingAdjustmentIncludedMoney, other.roundingAdjustmentIncludedMoney);
    }

    public String toString() {
        return "InvoicePaymentRequest [uid=" + this.uid + ", requestMethod=" + this.requestMethod + ", requestType=" + this.requestType + ", dueDate=" + this.dueDate + ", fixedAmountRequestedMoney=" + this.fixedAmountRequestedMoney + ", percentageRequested=" + this.percentageRequested + ", tippingEnabled=" + this.tippingEnabled + ", automaticPaymentSource=" + this.automaticPaymentSource + ", cardId=" + this.cardId + ", reminders=" + this.reminders + ", computedAmountMoney=" + this.computedAmountMoney + ", totalCompletedAmountMoney=" + this.totalCompletedAmountMoney + ", roundingAdjustmentIncludedMoney=" + this.roundingAdjustmentIncludedMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).requestMethod(this.getRequestMethod()).requestType(this.getRequestType()).dueDate(this.getDueDate()).fixedAmountRequestedMoney(this.getFixedAmountRequestedMoney()).percentageRequested(this.getPercentageRequested()).tippingEnabled(this.getTippingEnabled()).automaticPaymentSource(this.getAutomaticPaymentSource()).cardId(this.getCardId()).reminders(this.getReminders()).computedAmountMoney(this.getComputedAmountMoney()).totalCompletedAmountMoney(this.getTotalCompletedAmountMoney()).roundingAdjustmentIncludedMoney(this.getRoundingAdjustmentIncludedMoney());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String requestMethod;
        private String requestType;
        private String dueDate;
        private Money fixedAmountRequestedMoney;
        private String percentageRequested;
        private Boolean tippingEnabled;
        private String automaticPaymentSource;
        private String cardId;
        private List<InvoicePaymentReminder> reminders;
        private Money computedAmountMoney;
        private Money totalCompletedAmountMoney;
        private Money roundingAdjustmentIncludedMoney;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder fixedAmountRequestedMoney(Money fixedAmountRequestedMoney) {
            this.fixedAmountRequestedMoney = fixedAmountRequestedMoney;
            return this;
        }

        public Builder percentageRequested(String percentageRequested) {
            this.percentageRequested = percentageRequested;
            return this;
        }

        public Builder tippingEnabled(Boolean tippingEnabled) {
            this.tippingEnabled = tippingEnabled;
            return this;
        }

        public Builder automaticPaymentSource(String automaticPaymentSource) {
            this.automaticPaymentSource = automaticPaymentSource;
            return this;
        }

        public Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder reminders(List<InvoicePaymentReminder> reminders) {
            this.reminders = reminders;
            return this;
        }

        public Builder computedAmountMoney(Money computedAmountMoney) {
            this.computedAmountMoney = computedAmountMoney;
            return this;
        }

        public Builder totalCompletedAmountMoney(Money totalCompletedAmountMoney) {
            this.totalCompletedAmountMoney = totalCompletedAmountMoney;
            return this;
        }

        public Builder roundingAdjustmentIncludedMoney(Money roundingAdjustmentIncludedMoney) {
            this.roundingAdjustmentIncludedMoney = roundingAdjustmentIncludedMoney;
            return this;
        }

        public InvoicePaymentRequest build() {
            return new InvoicePaymentRequest(this.uid, this.requestMethod, this.requestType, this.dueDate, this.fixedAmountRequestedMoney, this.percentageRequested, this.tippingEnabled, this.automaticPaymentSource, this.cardId, this.reminders, this.computedAmountMoney, this.totalCompletedAmountMoney, this.roundingAdjustmentIncludedMoney);
        }
    }
}

