/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.InvoiceRecipientTaxIds;
import java.util.Objects;

public class InvoiceRecipient {
    private final String customerId;
    private final String givenName;
    private final String familyName;
    private final String emailAddress;
    private final Address address;
    private final String phoneNumber;
    private final String companyName;
    private final InvoiceRecipientTaxIds taxIds;

    @JsonCreator
    public InvoiceRecipient(@JsonProperty(value="customer_id") String customerId, @JsonProperty(value="given_name") String givenName, @JsonProperty(value="family_name") String familyName, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="address") Address address, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="company_name") String companyName, @JsonProperty(value="tax_ids") InvoiceRecipientTaxIds taxIds) {
        this.customerId = customerId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.companyName = companyName;
        this.taxIds = taxIds;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="given_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonGetter(value="family_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="company_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonGetter(value="tax_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InvoiceRecipientTaxIds getTaxIds() {
        return this.taxIds;
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.givenName, this.familyName, this.emailAddress, this.address, this.phoneNumber, this.companyName, this.taxIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoiceRecipient)) {
            return false;
        }
        InvoiceRecipient other = (InvoiceRecipient)obj;
        return Objects.equals(this.customerId, other.customerId) && Objects.equals(this.givenName, other.givenName) && Objects.equals(this.familyName, other.familyName) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.address, other.address) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.companyName, other.companyName) && Objects.equals(this.taxIds, other.taxIds);
    }

    public String toString() {
        return "InvoiceRecipient [customerId=" + this.customerId + ", givenName=" + this.givenName + ", familyName=" + this.familyName + ", emailAddress=" + this.emailAddress + ", address=" + this.address + ", phoneNumber=" + this.phoneNumber + ", companyName=" + this.companyName + ", taxIds=" + this.taxIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customerId(this.getCustomerId()).givenName(this.getGivenName()).familyName(this.getFamilyName()).emailAddress(this.getEmailAddress()).address(this.getAddress()).phoneNumber(this.getPhoneNumber()).companyName(this.getCompanyName()).taxIds(this.getTaxIds());
        return builder;
    }

    public static class Builder {
        private String customerId;
        private String givenName;
        private String familyName;
        private String emailAddress;
        private Address address;
        private String phoneNumber;
        private String companyName;
        private InvoiceRecipientTaxIds taxIds;

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder taxIds(InvoiceRecipientTaxIds taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public InvoiceRecipient build() {
            return new InvoiceRecipient(this.customerId, this.givenName, this.familyName, this.emailAddress, this.address, this.phoneNumber, this.companyName, this.taxIds);
        }
    }
}

