/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class ItemVariationLocationOverrides {
    private final String locationId;
    private final Money priceMoney;
    private final String pricingType;
    private final Boolean trackInventory;
    private final String inventoryAlertType;
    private final Long inventoryAlertThreshold;
    private final Boolean soldOut;
    private final String soldOutValidUntil;

    @JsonCreator
    public ItemVariationLocationOverrides(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="price_money") Money priceMoney, @JsonProperty(value="pricing_type") String pricingType, @JsonProperty(value="track_inventory") Boolean trackInventory, @JsonProperty(value="inventory_alert_type") String inventoryAlertType, @JsonProperty(value="inventory_alert_threshold") Long inventoryAlertThreshold, @JsonProperty(value="sold_out") Boolean soldOut, @JsonProperty(value="sold_out_valid_until") String soldOutValidUntil) {
        this.locationId = locationId;
        this.priceMoney = priceMoney;
        this.pricingType = pricingType;
        this.trackInventory = trackInventory;
        this.inventoryAlertType = inventoryAlertType;
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        this.soldOut = soldOut;
        this.soldOutValidUntil = soldOutValidUntil;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonGetter(value="pricing_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPricingType() {
        return this.pricingType;
    }

    @JsonGetter(value="track_inventory")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getTrackInventory() {
        return this.trackInventory;
    }

    @JsonGetter(value="inventory_alert_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    @JsonGetter(value="inventory_alert_threshold")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    @JsonGetter(value="sold_out")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSoldOut() {
        return this.soldOut;
    }

    @JsonGetter(value="sold_out_valid_until")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSoldOutValidUntil() {
        return this.soldOutValidUntil;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.soldOut, this.soldOutValidUntil);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ItemVariationLocationOverrides)) {
            return false;
        }
        ItemVariationLocationOverrides other = (ItemVariationLocationOverrides)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.priceMoney, other.priceMoney) && Objects.equals(this.pricingType, other.pricingType) && Objects.equals(this.trackInventory, other.trackInventory) && Objects.equals(this.inventoryAlertType, other.inventoryAlertType) && Objects.equals(this.inventoryAlertThreshold, other.inventoryAlertThreshold) && Objects.equals(this.soldOut, other.soldOut) && Objects.equals(this.soldOutValidUntil, other.soldOutValidUntil);
    }

    public String toString() {
        return "ItemVariationLocationOverrides [locationId=" + this.locationId + ", priceMoney=" + this.priceMoney + ", pricingType=" + this.pricingType + ", trackInventory=" + this.trackInventory + ", inventoryAlertType=" + this.inventoryAlertType + ", inventoryAlertThreshold=" + this.inventoryAlertThreshold + ", soldOut=" + this.soldOut + ", soldOutValidUntil=" + this.soldOutValidUntil + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationId(this.getLocationId()).priceMoney(this.getPriceMoney()).pricingType(this.getPricingType()).trackInventory(this.getTrackInventory()).inventoryAlertType(this.getInventoryAlertType()).inventoryAlertThreshold(this.getInventoryAlertThreshold()).soldOut(this.getSoldOut()).soldOutValidUntil(this.getSoldOutValidUntil());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private Money priceMoney;
        private String pricingType;
        private Boolean trackInventory;
        private String inventoryAlertType;
        private Long inventoryAlertThreshold;
        private Boolean soldOut;
        private String soldOutValidUntil;

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder pricingType(String pricingType) {
            this.pricingType = pricingType;
            return this;
        }

        public Builder trackInventory(Boolean trackInventory) {
            this.trackInventory = trackInventory;
            return this;
        }

        public Builder inventoryAlertType(String inventoryAlertType) {
            this.inventoryAlertType = inventoryAlertType;
            return this;
        }

        public Builder inventoryAlertThreshold(Long inventoryAlertThreshold) {
            this.inventoryAlertThreshold = inventoryAlertThreshold;
            return this;
        }

        public Builder soldOut(Boolean soldOut) {
            this.soldOut = soldOut;
            return this;
        }

        public Builder soldOutValidUntil(String soldOutValidUntil) {
            this.soldOutValidUntil = soldOutValidUntil;
            return this;
        }

        public ItemVariationLocationOverrides build() {
            return new ItemVariationLocationOverrides(this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.soldOut, this.soldOutValidUntil);
        }
    }
}

