/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class JobAssignment {
    private final String jobTitle;
    private final String payType;
    private final Money hourlyRate;
    private final Money annualRate;
    private final Integer weeklyHours;

    @JsonCreator
    public JobAssignment(@JsonProperty(value="job_title") String jobTitle, @JsonProperty(value="pay_type") String payType, @JsonProperty(value="hourly_rate") Money hourlyRate, @JsonProperty(value="annual_rate") Money annualRate, @JsonProperty(value="weekly_hours") Integer weeklyHours) {
        this.jobTitle = jobTitle;
        this.payType = payType;
        this.hourlyRate = hourlyRate;
        this.annualRate = annualRate;
        this.weeklyHours = weeklyHours;
    }

    @JsonGetter(value="job_title")
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonGetter(value="pay_type")
    public String getPayType() {
        return this.payType;
    }

    @JsonGetter(value="hourly_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    @JsonGetter(value="annual_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAnnualRate() {
        return this.annualRate;
    }

    @JsonGetter(value="weekly_hours")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getWeeklyHours() {
        return this.weeklyHours;
    }

    public int hashCode() {
        return Objects.hash(this.jobTitle, this.payType, this.hourlyRate, this.annualRate, this.weeklyHours);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JobAssignment)) {
            return false;
        }
        JobAssignment other = (JobAssignment)obj;
        return Objects.equals(this.jobTitle, other.jobTitle) && Objects.equals(this.payType, other.payType) && Objects.equals(this.hourlyRate, other.hourlyRate) && Objects.equals(this.annualRate, other.annualRate) && Objects.equals(this.weeklyHours, other.weeklyHours);
    }

    public String toString() {
        return "JobAssignment [jobTitle=" + this.jobTitle + ", payType=" + this.payType + ", hourlyRate=" + this.hourlyRate + ", annualRate=" + this.annualRate + ", weeklyHours=" + this.weeklyHours + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.jobTitle, this.payType).hourlyRate(this.getHourlyRate()).annualRate(this.getAnnualRate()).weeklyHours(this.getWeeklyHours());
        return builder;
    }

    public static class Builder {
        private String jobTitle;
        private String payType;
        private Money hourlyRate;
        private Money annualRate;
        private Integer weeklyHours;

        public Builder(String jobTitle, String payType) {
            this.jobTitle = jobTitle;
            this.payType = payType;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public Builder payType(String payType) {
            this.payType = payType;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public Builder annualRate(Money annualRate) {
            this.annualRate = annualRate;
            return this;
        }

        public Builder weeklyHours(Integer weeklyHours) {
            this.weeklyHours = weeklyHours;
            return this;
        }

        public JobAssignment build() {
            return new JobAssignment(this.jobTitle, this.payType, this.hourlyRate, this.annualRate, this.weeklyHours);
        }
    }
}

