/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListBankAccountsRequest {
    private final String cursor;
    private final Integer limit;
    private final String locationId;

    @JsonCreator
    public ListBankAccountsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="location_id") String locationId) {
        this.cursor = cursor;
        this.limit = limit;
        this.locationId = locationId;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBankAccountsRequest)) {
            return false;
        }
        ListBankAccountsRequest other = (ListBankAccountsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "ListBankAccountsRequest [cursor=" + this.cursor + ", limit=" + this.limit + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).limit(this.getLimit()).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private Integer limit;
        private String locationId;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public ListBankAccountsRequest build() {
            return new ListBankAccountsRequest(this.cursor, this.limit, this.locationId);
        }
    }
}

