/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.BankAccount;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListBankAccountsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<BankAccount> bankAccounts;
    private final String cursor;

    @JsonCreator
    public ListBankAccountsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="bank_accounts") List<BankAccount> bankAccounts, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.bankAccounts = bankAccounts;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="bank_accounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<BankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.bankAccounts, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBankAccountsResponse)) {
            return false;
        }
        ListBankAccountsResponse other = (ListBankAccountsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.bankAccounts, other.bankAccounts) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListBankAccountsResponse [errors=" + this.errors + ", bankAccounts=" + this.bankAccounts + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).bankAccounts(this.getBankAccounts()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<BankAccount> bankAccounts;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder bankAccounts(List<BankAccount> bankAccounts) {
            this.bankAccounts = bankAccounts;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListBankAccountsResponse build() {
            ListBankAccountsResponse model = new ListBankAccountsResponse(this.errors, this.bankAccounts, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

