/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListBookingsRequest {
    private final Integer limit;
    private final String cursor;
    private final String teamMemberId;
    private final String locationId;
    private final String startAtMin;
    private final String startAtMax;

    @JsonCreator
    public ListBookingsRequest(@JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="start_at_min") String startAtMin, @JsonProperty(value="start_at_max") String startAtMax) {
        this.limit = limit;
        this.cursor = cursor;
        this.teamMemberId = teamMemberId;
        this.locationId = locationId;
        this.startAtMin = startAtMin;
        this.startAtMax = startAtMax;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="start_at_min")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartAtMin() {
        return this.startAtMin;
    }

    @JsonGetter(value="start_at_max")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartAtMax() {
        return this.startAtMax;
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.cursor, this.teamMemberId, this.locationId, this.startAtMin, this.startAtMax);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBookingsRequest)) {
            return false;
        }
        ListBookingsRequest other = (ListBookingsRequest)obj;
        return Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.startAtMin, other.startAtMin) && Objects.equals(this.startAtMax, other.startAtMax);
    }

    public String toString() {
        return "ListBookingsRequest [limit=" + this.limit + ", cursor=" + this.cursor + ", teamMemberId=" + this.teamMemberId + ", locationId=" + this.locationId + ", startAtMin=" + this.startAtMin + ", startAtMax=" + this.startAtMax + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().limit(this.getLimit()).cursor(this.getCursor()).teamMemberId(this.getTeamMemberId()).locationId(this.getLocationId()).startAtMin(this.getStartAtMin()).startAtMax(this.getStartAtMax());
        return builder;
    }

    public static class Builder {
        private Integer limit;
        private String cursor;
        private String teamMemberId;
        private String locationId;
        private String startAtMin;
        private String startAtMax;

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder startAtMin(String startAtMin) {
            this.startAtMin = startAtMin;
            return this;
        }

        public Builder startAtMax(String startAtMax) {
            this.startAtMax = startAtMax;
            return this;
        }

        public ListBookingsRequest build() {
            return new ListBookingsRequest(this.limit, this.cursor, this.teamMemberId, this.locationId, this.startAtMin, this.startAtMax);
        }
    }
}

