/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Booking;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListBookingsResponse {
    private HttpContext httpContext;
    private final List<Booking> bookings;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListBookingsResponse(@JsonProperty(value="bookings") List<Booking> bookings, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.bookings = bookings;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="bookings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Booking> getBookings() {
        return this.bookings;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.bookings, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBookingsResponse)) {
            return false;
        }
        ListBookingsResponse other = (ListBookingsResponse)obj;
        return Objects.equals(this.bookings, other.bookings) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListBookingsResponse [bookings=" + this.bookings + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().bookings(this.getBookings()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Booking> bookings;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder bookings(List<Booking> bookings) {
            this.bookings = bookings;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListBookingsResponse build() {
            ListBookingsResponse model = new ListBookingsResponse(this.bookings, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

