/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListCardsRequest {
    private final String cursor;
    private final String customerId;
    private final Boolean includeDisabled;
    private final String referenceId;
    private final String sortOrder;

    @JsonCreator
    public ListCardsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="include_disabled") Boolean includeDisabled, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="sort_order") String sortOrder) {
        this.cursor = cursor;
        this.customerId = customerId;
        this.includeDisabled = includeDisabled;
        this.referenceId = referenceId;
        this.sortOrder = sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="include_disabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeDisabled() {
        return this.includeDisabled;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.customerId, this.includeDisabled, this.referenceId, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCardsRequest)) {
            return false;
        }
        ListCardsRequest other = (ListCardsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.includeDisabled, other.includeDisabled) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public String toString() {
        return "ListCardsRequest [cursor=" + this.cursor + ", customerId=" + this.customerId + ", includeDisabled=" + this.includeDisabled + ", referenceId=" + this.referenceId + ", sortOrder=" + this.sortOrder + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).customerId(this.getCustomerId()).includeDisabled(this.getIncludeDisabled()).referenceId(this.getReferenceId()).sortOrder(this.getSortOrder());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private String customerId;
        private Boolean includeDisabled;
        private String referenceId;
        private String sortOrder;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder includeDisabled(Boolean includeDisabled) {
            this.includeDisabled = includeDisabled;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListCardsRequest build() {
            return new ListCardsRequest(this.cursor, this.customerId, this.includeDisabled, this.referenceId, this.sortOrder);
        }
    }
}

