/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Card;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCardsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Card> cards;
    private final String cursor;

    @JsonCreator
    public ListCardsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="cards") List<Card> cards, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.cards = cards;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="cards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Card> getCards() {
        return this.cards;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.cards, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCardsResponse)) {
            return false;
        }
        ListCardsResponse other = (ListCardsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.cards, other.cards) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCardsResponse [errors=" + this.errors + ", cards=" + this.cards + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).cards(this.getCards()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Card> cards;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder cards(List<Card> cards) {
            this.cards = cards;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListCardsResponse build() {
            ListCardsResponse model = new ListCardsResponse(this.errors, this.cards, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

