/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListCashDrawerShiftEventsRequest {
    private final String locationId;
    private final Integer limit;
    private final String cursor;

    @JsonCreator
    public ListCashDrawerShiftEventsRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.locationId = locationId;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftEventsRequest)) {
            return false;
        }
        ListCashDrawerShiftEventsRequest other = (ListCashDrawerShiftEventsRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCashDrawerShiftEventsRequest [locationId=" + this.locationId + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId).limit(this.getLimit()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private Integer limit;
        private String cursor;

        public Builder(String locationId) {
            this.locationId = locationId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListCashDrawerShiftEventsRequest build() {
            return new ListCashDrawerShiftEventsRequest(this.locationId, this.limit, this.cursor);
        }
    }
}

