/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CashDrawerShiftEvent;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCashDrawerShiftEventsResponse {
    private HttpContext httpContext;
    private final List<CashDrawerShiftEvent> events;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListCashDrawerShiftEventsResponse(@JsonProperty(value="events") List<CashDrawerShiftEvent> events, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.events = events;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="events")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CashDrawerShiftEvent> getEvents() {
        return this.events;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.events, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftEventsResponse)) {
            return false;
        }
        ListCashDrawerShiftEventsResponse other = (ListCashDrawerShiftEventsResponse)obj;
        return Objects.equals(this.events, other.events) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListCashDrawerShiftEventsResponse [events=" + this.events + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().events(this.getEvents()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<CashDrawerShiftEvent> events;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder events(List<CashDrawerShiftEvent> events) {
            this.events = events;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListCashDrawerShiftEventsResponse build() {
            ListCashDrawerShiftEventsResponse model = new ListCashDrawerShiftEventsResponse(this.events, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

