/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListCashDrawerShiftsRequest {
    private final String locationId;
    private final String sortOrder;
    private final String beginTime;
    private final String endTime;
    private final Integer limit;
    private final String cursor;

    @JsonCreator
    public ListCashDrawerShiftsRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.locationId = locationId;
        this.sortOrder = sortOrder;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBeginTime() {
        return this.beginTime;
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndTime() {
        return this.endTime;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.sortOrder, this.beginTime, this.endTime, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftsRequest)) {
            return false;
        }
        ListCashDrawerShiftsRequest other = (ListCashDrawerShiftsRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCashDrawerShiftsRequest [locationId=" + this.locationId + ", sortOrder=" + this.sortOrder + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId).sortOrder(this.getSortOrder()).beginTime(this.getBeginTime()).endTime(this.getEndTime()).limit(this.getLimit()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String sortOrder;
        private String beginTime;
        private String endTime;
        private Integer limit;
        private String cursor;

        public Builder(String locationId) {
            this.locationId = locationId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListCashDrawerShiftsRequest build() {
            return new ListCashDrawerShiftsRequest(this.locationId, this.sortOrder, this.beginTime, this.endTime, this.limit, this.cursor);
        }
    }
}

