/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListCatalogRequest {
    private final String cursor;
    private final String types;
    private final Long catalogVersion;

    @JsonCreator
    public ListCatalogRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="types") String types, @JsonProperty(value="catalog_version") Long catalogVersion) {
        this.cursor = cursor;
        this.types = types;
        this.catalogVersion = catalogVersion;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTypes() {
        return this.types;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.types, this.catalogVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCatalogRequest)) {
            return false;
        }
        ListCatalogRequest other = (ListCatalogRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.types, other.types) && Objects.equals(this.catalogVersion, other.catalogVersion);
    }

    public String toString() {
        return "ListCatalogRequest [cursor=" + this.cursor + ", types=" + this.types + ", catalogVersion=" + this.catalogVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).types(this.getTypes()).catalogVersion(this.getCatalogVersion());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private String types;
        private Long catalogVersion;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder types(String types) {
            this.types = types;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public ListCatalogRequest build() {
            return new ListCatalogRequest(this.cursor, this.types, this.catalogVersion);
        }
    }
}

