/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomerGroup;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCustomerGroupsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<CustomerGroup> groups;
    private final String cursor;

    @JsonCreator
    public ListCustomerGroupsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="groups") List<CustomerGroup> groups, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.groups = groups;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="groups")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CustomerGroup> getGroups() {
        return this.groups;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.groups, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomerGroupsResponse)) {
            return false;
        }
        ListCustomerGroupsResponse other = (ListCustomerGroupsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.groups, other.groups) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCustomerGroupsResponse [errors=" + this.errors + ", groups=" + this.groups + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).groups(this.getGroups()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<CustomerGroup> groups;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder groups(List<CustomerGroup> groups) {
            this.groups = groups;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListCustomerGroupsResponse build() {
            ListCustomerGroupsResponse model = new ListCustomerGroupsResponse(this.errors, this.groups, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

