/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListCustomersRequest {
    private final String cursor;
    private final Integer limit;
    private final String sortField;
    private final String sortOrder;

    @JsonCreator
    public ListCustomersRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="sort_field") String sortField, @JsonProperty(value="sort_order") String sortOrder) {
        this.cursor = cursor;
        this.limit = limit;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="sort_field")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortField() {
        return this.sortField;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.sortField, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomersRequest)) {
            return false;
        }
        ListCustomersRequest other = (ListCustomersRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sortField, other.sortField) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public String toString() {
        return "ListCustomersRequest [cursor=" + this.cursor + ", limit=" + this.limit + ", sortField=" + this.sortField + ", sortOrder=" + this.sortOrder + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).limit(this.getLimit()).sortField(this.getSortField()).sortOrder(this.getSortOrder());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private Integer limit;
        private String sortField;
        private String sortOrder;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListCustomersRequest build() {
            return new ListCustomersRequest(this.cursor, this.limit, this.sortField, this.sortOrder);
        }
    }
}

