/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class ListDeviceCodesRequest {
    private final String cursor;
    private final String locationId;
    private final String productType;
    private final List<String> status;

    @JsonCreator
    public ListDeviceCodesRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="product_type") String productType, @JsonProperty(value="status") List<String> status) {
        this.cursor = cursor;
        this.locationId = locationId;
        this.productType = productType;
        this.status = status;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="product_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProductType() {
        return this.productType;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.locationId, this.productType, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDeviceCodesRequest)) {
            return false;
        }
        ListDeviceCodesRequest other = (ListDeviceCodesRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.productType, other.productType) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "ListDeviceCodesRequest [cursor=" + this.cursor + ", locationId=" + this.locationId + ", productType=" + this.productType + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).locationId(this.getLocationId()).productType(this.getProductType()).status(this.getStatus());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private String locationId;
        private String productType;
        private List<String> status;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        public Builder status(List<String> status) {
            this.status = status;
            return this;
        }

        public ListDeviceCodesRequest build() {
            return new ListDeviceCodesRequest(this.cursor, this.locationId, this.productType, this.status);
        }
    }
}

