/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.DeviceCode;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListDeviceCodesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<DeviceCode> deviceCodes;
    private final String cursor;

    @JsonCreator
    public ListDeviceCodesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="device_codes") List<DeviceCode> deviceCodes, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.deviceCodes = deviceCodes;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="device_codes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<DeviceCode> getDeviceCodes() {
        return this.deviceCodes;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.deviceCodes, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDeviceCodesResponse)) {
            return false;
        }
        ListDeviceCodesResponse other = (ListDeviceCodesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.deviceCodes, other.deviceCodes) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListDeviceCodesResponse [errors=" + this.errors + ", deviceCodes=" + this.deviceCodes + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).deviceCodes(this.getDeviceCodes()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<DeviceCode> deviceCodes;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder deviceCodes(List<DeviceCode> deviceCodes) {
            this.deviceCodes = deviceCodes;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListDeviceCodesResponse build() {
            ListDeviceCodesResponse model = new ListDeviceCodesResponse(this.errors, this.deviceCodes, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

