/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class ListDisputesRequest {
    private final String cursor;
    private final List<String> states;
    private final String locationId;

    @JsonCreator
    public ListDisputesRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="states") List<String> states, @JsonProperty(value="location_id") String locationId) {
        this.cursor = cursor;
        this.states = states;
        this.locationId = locationId;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getStates() {
        return this.states;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.states, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDisputesRequest)) {
            return false;
        }
        ListDisputesRequest other = (ListDisputesRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.states, other.states) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "ListDisputesRequest [cursor=" + this.cursor + ", states=" + this.states + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).states(this.getStates()).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private List<String> states;
        private String locationId;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = states;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public ListDisputesRequest build() {
            return new ListDisputesRequest(this.cursor, this.states, this.locationId);
        }
    }
}

