/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListEmployeeWagesRequest {
    private final String employeeId;
    private final Integer limit;
    private final String cursor;

    @JsonCreator
    public ListEmployeeWagesRequest(@JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.employeeId = employeeId;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmployeeId() {
        return this.employeeId;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.employeeId, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListEmployeeWagesRequest)) {
            return false;
        }
        ListEmployeeWagesRequest other = (ListEmployeeWagesRequest)obj;
        return Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListEmployeeWagesRequest [employeeId=" + this.employeeId + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().employeeId(this.getEmployeeId()).limit(this.getLimit()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private String employeeId;
        private Integer limit;
        private String cursor;

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListEmployeeWagesRequest build() {
            return new ListEmployeeWagesRequest(this.employeeId, this.limit, this.cursor);
        }
    }
}

