/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.GiftCardActivity;
import java.util.List;
import java.util.Objects;

public class ListGiftCardActivitiesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<GiftCardActivity> giftCardActivities;
    private final String cursor;

    @JsonCreator
    public ListGiftCardActivitiesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="gift_card_activities") List<GiftCardActivity> giftCardActivities, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.giftCardActivities = giftCardActivities;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="gift_card_activities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<GiftCardActivity> getGiftCardActivities() {
        return this.giftCardActivities;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.giftCardActivities, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListGiftCardActivitiesResponse)) {
            return false;
        }
        ListGiftCardActivitiesResponse other = (ListGiftCardActivitiesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.giftCardActivities, other.giftCardActivities) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListGiftCardActivitiesResponse [errors=" + this.errors + ", giftCardActivities=" + this.giftCardActivities + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).giftCardActivities(this.getGiftCardActivities()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<GiftCardActivity> giftCardActivities;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder giftCardActivities(List<GiftCardActivity> giftCardActivities) {
            this.giftCardActivities = giftCardActivities;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListGiftCardActivitiesResponse build() {
            ListGiftCardActivitiesResponse model = new ListGiftCardActivitiesResponse(this.errors, this.giftCardActivities, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

