/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.GiftCard;
import java.util.List;
import java.util.Objects;

public class ListGiftCardsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<GiftCard> giftCards;
    private final String cursor;

    @JsonCreator
    public ListGiftCardsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="gift_cards") List<GiftCard> giftCards, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.giftCards = giftCards;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="gift_cards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<GiftCard> getGiftCards() {
        return this.giftCards;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.giftCards, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListGiftCardsResponse)) {
            return false;
        }
        ListGiftCardsResponse other = (ListGiftCardsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.giftCards, other.giftCards) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListGiftCardsResponse [errors=" + this.errors + ", giftCards=" + this.giftCards + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).giftCards(this.getGiftCards()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<GiftCard> giftCards;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder giftCards(List<GiftCard> giftCards) {
            this.giftCards = giftCards;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListGiftCardsResponse build() {
            ListGiftCardsResponse model = new ListGiftCardsResponse(this.errors, this.giftCards, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

