/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListInvoicesRequest {
    private final String locationId;
    private final String cursor;
    private final Integer limit;

    @JsonCreator
    public ListInvoicesRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit) {
        this.locationId = locationId;
        this.cursor = cursor;
        this.limit = limit;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.cursor, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListInvoicesRequest)) {
            return false;
        }
        ListInvoicesRequest other = (ListInvoicesRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "ListInvoicesRequest [locationId=" + this.locationId + ", cursor=" + this.cursor + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId).cursor(this.getCursor()).limit(this.getLimit());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String cursor;
        private Integer limit;

        public Builder(String locationId) {
            this.locationId = locationId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListInvoicesRequest build() {
            return new ListInvoicesRequest(this.locationId, this.cursor, this.limit);
        }
    }
}

