/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyProgram;
import java.util.List;
import java.util.Objects;

public class ListLoyaltyProgramsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<LoyaltyProgram> programs;

    @JsonCreator
    public ListLoyaltyProgramsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="programs") List<LoyaltyProgram> programs) {
        this.errors = errors;
        this.programs = programs;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="programs")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyProgram> getPrograms() {
        return this.programs;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.programs);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListLoyaltyProgramsResponse)) {
            return false;
        }
        ListLoyaltyProgramsResponse other = (ListLoyaltyProgramsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.programs, other.programs);
    }

    public String toString() {
        return "ListLoyaltyProgramsResponse [errors=" + this.errors + ", programs=" + this.programs + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).programs(this.getPrograms());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<LoyaltyProgram> programs;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder programs(List<LoyaltyProgram> programs) {
            this.programs = programs;
            return this;
        }

        public ListLoyaltyProgramsResponse build() {
            ListLoyaltyProgramsResponse model = new ListLoyaltyProgramsResponse(this.errors, this.programs);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

