/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.PaymentLink;
import java.util.List;
import java.util.Objects;

public class ListPaymentLinksResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<PaymentLink> paymentLinks;
    private final String cursor;

    @JsonCreator
    public ListPaymentLinksResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="payment_links") List<PaymentLink> paymentLinks, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.paymentLinks = paymentLinks;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="payment_links")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PaymentLink> getPaymentLinks() {
        return this.paymentLinks;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.paymentLinks, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListPaymentLinksResponse)) {
            return false;
        }
        ListPaymentLinksResponse other = (ListPaymentLinksResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.paymentLinks, other.paymentLinks) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListPaymentLinksResponse [errors=" + this.errors + ", paymentLinks=" + this.paymentLinks + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).paymentLinks(this.getPaymentLinks()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<PaymentLink> paymentLinks;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder paymentLinks(List<PaymentLink> paymentLinks) {
            this.paymentLinks = paymentLinks;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListPaymentLinksResponse build() {
            ListPaymentLinksResponse model = new ListPaymentLinksResponse(this.errors, this.paymentLinks, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

