/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Payment;
import java.util.List;
import java.util.Objects;

public class ListPaymentsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Payment> payments;
    private final String cursor;

    @JsonCreator
    public ListPaymentsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="payments") List<Payment> payments, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.payments = payments;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="payments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Payment> getPayments() {
        return this.payments;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.payments, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListPaymentsResponse)) {
            return false;
        }
        ListPaymentsResponse other = (ListPaymentsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.payments, other.payments) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListPaymentsResponse [errors=" + this.errors + ", payments=" + this.payments + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).payments(this.getPayments()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Payment> payments;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder payments(List<Payment> payments) {
            this.payments = payments;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListPaymentsResponse build() {
            ListPaymentsResponse model = new ListPaymentsResponse(this.errors, this.payments, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

