/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListPayoutEntriesRequest {
    private final String sortOrder;
    private final String cursor;
    private final Integer limit;

    @JsonCreator
    public ListPayoutEntriesRequest(@JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit) {
        this.sortOrder = sortOrder;
        this.cursor = cursor;
        this.limit = limit;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.sortOrder, this.cursor, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListPayoutEntriesRequest)) {
            return false;
        }
        ListPayoutEntriesRequest other = (ListPayoutEntriesRequest)obj;
        return Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "ListPayoutEntriesRequest [sortOrder=" + this.sortOrder + ", cursor=" + this.cursor + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortOrder(this.getSortOrder()).cursor(this.getCursor()).limit(this.getLimit());
        return builder;
    }

    public static class Builder {
        private String sortOrder;
        private String cursor;
        private Integer limit;

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListPayoutEntriesRequest build() {
            return new ListPayoutEntriesRequest(this.sortOrder, this.cursor, this.limit);
        }
    }
}

