/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListPayoutsRequest {
    private final String locationId;
    private final String status;
    private final String beginTime;
    private final String endTime;
    private final String sortOrder;
    private final String cursor;
    private final Integer limit;

    @JsonCreator
    public ListPayoutsRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="status") String status, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit) {
        this.locationId = locationId;
        this.status = status;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.sortOrder = sortOrder;
        this.cursor = cursor;
        this.limit = limit;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBeginTime() {
        return this.beginTime;
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndTime() {
        return this.endTime;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.status, this.beginTime, this.endTime, this.sortOrder, this.cursor, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListPayoutsRequest)) {
            return false;
        }
        ListPayoutsRequest other = (ListPayoutsRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.status, other.status) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "ListPayoutsRequest [locationId=" + this.locationId + ", status=" + this.status + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", sortOrder=" + this.sortOrder + ", cursor=" + this.cursor + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationId(this.getLocationId()).status(this.getStatus()).beginTime(this.getBeginTime()).endTime(this.getEndTime()).sortOrder(this.getSortOrder()).cursor(this.getCursor()).limit(this.getLimit());
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String status;
        private String beginTime;
        private String endTime;
        private String sortOrder;
        private String cursor;
        private Integer limit;

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListPayoutsRequest build() {
            return new ListPayoutsRequest(this.locationId, this.status, this.beginTime, this.endTime, this.sortOrder, this.cursor, this.limit);
        }
    }
}

