/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Payout;
import java.util.List;
import java.util.Objects;

public class ListPayoutsResponse {
    private HttpContext httpContext;
    private final List<Payout> payouts;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListPayoutsResponse(@JsonProperty(value="payouts") List<Payout> payouts, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.payouts = payouts;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="payouts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Payout> getPayouts() {
        return this.payouts;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.payouts, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListPayoutsResponse)) {
            return false;
        }
        ListPayoutsResponse other = (ListPayoutsResponse)obj;
        return Objects.equals(this.payouts, other.payouts) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListPayoutsResponse [payouts=" + this.payouts + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().payouts(this.getPayouts()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Payout> payouts;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder payouts(List<Payout> payouts) {
            this.payouts = payouts;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListPayoutsResponse build() {
            ListPayoutsResponse model = new ListPayoutsResponse(this.payouts, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

