/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Site;
import java.util.List;
import java.util.Objects;

public class ListSitesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Site> sites;

    @JsonCreator
    public ListSitesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="sites") List<Site> sites) {
        this.errors = errors;
        this.sites = sites;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="sites")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Site> getSites() {
        return this.sites;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.sites);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListSitesResponse)) {
            return false;
        }
        ListSitesResponse other = (ListSitesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.sites, other.sites);
    }

    public String toString() {
        return "ListSitesResponse [errors=" + this.errors + ", sites=" + this.sites + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).sites(this.getSites());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Site> sites;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder sites(List<Site> sites) {
            this.sites = sites;
            return this;
        }

        public ListSitesResponse build() {
            ListSitesResponse model = new ListSitesResponse(this.errors, this.sites);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

