/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.SubscriptionEvent;
import java.util.List;
import java.util.Objects;

public class ListSubscriptionEventsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<SubscriptionEvent> subscriptionEvents;
    private final String cursor;

    @JsonCreator
    public ListSubscriptionEventsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="subscription_events") List<SubscriptionEvent> subscriptionEvents, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.subscriptionEvents = subscriptionEvents;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="subscription_events")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<SubscriptionEvent> getSubscriptionEvents() {
        return this.subscriptionEvents;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscriptionEvents, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListSubscriptionEventsResponse)) {
            return false;
        }
        ListSubscriptionEventsResponse other = (ListSubscriptionEventsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.subscriptionEvents, other.subscriptionEvents) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListSubscriptionEventsResponse [errors=" + this.errors + ", subscriptionEvents=" + this.subscriptionEvents + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).subscriptionEvents(this.getSubscriptionEvents()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<SubscriptionEvent> subscriptionEvents;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder subscriptionEvents(List<SubscriptionEvent> subscriptionEvents) {
            this.subscriptionEvents = subscriptionEvents;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListSubscriptionEventsResponse build() {
            ListSubscriptionEventsResponse model = new ListSubscriptionEventsResponse(this.errors, this.subscriptionEvents, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

