/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ListTransactionsRequest {
    private final String beginTime;
    private final String endTime;
    private final String sortOrder;
    private final String cursor;

    @JsonCreator
    public ListTransactionsRequest(@JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="cursor") String cursor) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.sortOrder = sortOrder;
        this.cursor = cursor;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBeginTime() {
        return this.beginTime;
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndTime() {
        return this.endTime;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.beginTime, this.endTime, this.sortOrder, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListTransactionsRequest)) {
            return false;
        }
        ListTransactionsRequest other = (ListTransactionsRequest)obj;
        return Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListTransactionsRequest [beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", sortOrder=" + this.sortOrder + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().beginTime(this.getBeginTime()).endTime(this.getEndTime()).sortOrder(this.getSortOrder()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private String beginTime;
        private String endTime;
        private String sortOrder;
        private String cursor;

        public Builder beginTime(String beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListTransactionsRequest build() {
            return new ListTransactionsRequest(this.beginTime, this.endTime, this.sortOrder, this.cursor);
        }
    }
}

